import pytest
from xml.etree.ElementTree import tostring
from app.domain.edi.models import Buyer


@pytest.fixture
def sample_buyer():
    return Buyer(
        iln="5909000829350",
        tax_id="1132847981",
        name="FRISCO SPÓŁKA AKCYJNA",
        street_and_number="GROCHOWSKA 306/308",
        city_name="WARSZAWA",
        postal_code="03-840",
        country="PL",
    )


def test_to_xml_returns_element(sample_buyer):
    xml_el = sample_buyer.to_xml()
    assert xml_el.tag == "Buyer", "Root element should be <Buyer>"
    expected_tags = {
        "ILN",
        "TaxID",
        "Name",
        "StreetAndNumber",
        "CityName",
        "PostalCode",
        "Country",
    }
    actual_tags = {child.tag for child in xml_el}
    assert expected_tags == actual_tags, "Missing or unexpected child tags in Buyer XML"


def test_to_xml_contains_expected_values(sample_buyer):
    xml_str = tostring(sample_buyer.to_xml(), encoding="unicode")
    assert "<ILN>5909000829350</ILN>" in xml_str
    assert "<TaxID>1132847981</TaxID>" in xml_str
    assert "<Name>FRISCO SPÓŁKA AKCYJNA</Name>" in xml_str
    assert "<StreetAndNumber>GROCHOWSKA 306/308</StreetAndNumber>" in xml_str
    assert "<CityName>WARSZAWA</CityName>" in xml_str
    assert "<PostalCode>03-840</PostalCode>" in xml_str
    assert "<Country>PL</Country>" in xml_str
