from app.domain.converters.utils import get_invoice_payment_means
from app.domain.edi.models.edi_line_item import InvoicePaymentMeans

import pytest


@pytest.mark.parametrize(
    "value",
    [
        "przelew",
        "przelew." "Przelew",
        "Przelew.",
        "Przelew na konto bankowe",
    ],
)
def test_get_invoice_payment_means_returns_wire_transfer_if_expected(value: str):
    r = get_invoice_payment_means(value)
    assert r == InvoicePaymentMeans.WIRE_TRANSFER
