from os.path import dirname, join

from app.domain.converters import convert_to_line_item
from app.domain.edi.models import LineItem
from app.domain.epp.parser import Parser

with open(join(dirname(__file__), "test.epp"), "r") as f:
    TEST_STRING = f.read()

document = Parser().parse(TEST_STRING)


def test_returns_instance_of_line_item():
    r = convert_to_line_item(document.get_line_items_from_all_documents()[0], document)
    assert isinstance(r, LineItem), "Expected result to be a EDI LineItem"


def test_returns_expected_barcode():
    r = convert_to_line_item(document.get_line_items_from_all_documents()[0], document)
    assert r.ean == "5906745602392", "Incorrect barcode"


def test_returns_expected_tax_values():
    r = convert_to_line_item(document.get_line_items_from_all_documents()[0], document)
    assert r.tax_rate == 23, "Expected value of tax_rate to be 23"
    assert r.tax_amount == 27.86, "Expected value of tax_amount to be 27.86"
