from dataclasses import dataclass

from app.infra.parser import Args

from .constants import DEFAULT_KEEP_FILES


@dataclass
class Options:
    args: Args
    keep_files: bool = False

    @staticmethod
    def create(args, keep_files=DEFAULT_KEEP_FILES):
        return Options(
            args=args,
            keep_files=keep_files,
        )
