from loguru import logger

from app.domain.config import Config
from app.infra.command_handlers import AddNipCommandHandler
from app.infra.command_handlers import InitCommandHandler
from app.infra.command_handlers import RunCommandHandler
from app.infra.command_handlers import TestCommandHandler
from app.infra.command_handlers import WatchCommandHandler
from app.infra.command_handlers import WorkCommandHandler
from app.infra.parser import Args
from app.infra.parser import parse_args
from app.infra.setup_configuration import get_config


def run_app() -> int:
    """ Run the application. """
    args: Args = parse_args()
    config: Config = get_config(args)
    app = Application(config, args)
    return app.run()

class Application:
    """Application class."""
    command_handler_classes = [
        RunCommandHandler,
        WatchCommandHandler,
        WorkCommandHandler,
        InitCommandHandler,
        TestCommandHandler,
        AddNipCommandHandler,
    ]

    def __init__(self, config: Config, args: Args):
        self.config = config
        self.args = args

    def get_handler(self, command):
        for handler_class in self.command_handler_classes:
            handler = handler_class(self.args, self.config)
            if handler.can_handle(command):
                return handler
        return None

    # noinspection PyMethodMayBeStatic
    def run(self) -> int:
        if self.args.keep_files:
            logger.warning("Running application in keep files mode. No files will be moved after processing.")
        handler = self.get_handler(self.args.command)
        if not handler:
            logger.error(f"No handler for command '{self.args.command}'.")
            return 1
        return handler.handle(self.args.command)