from xml.etree.ElementTree import Element, SubElement


class TaxSummaryLine:
    def __init__(
        self,
        tax_rate: float,
        tax_category_code: str,
        tax_amount: float,
        taxable_basis: float,
        taxable_amount: float,
        gross_amount: float,
        _validate: bool = True,
    ):
        if _validate:
            if not isinstance(tax_rate, float):
                raise TypeError("tax_rate must be float")
            if not isinstance(tax_category_code, str):
                raise TypeError("tax_category_code must be str")
            if not isinstance(tax_amount, float):
                raise TypeError("tax_amount must be float")
            if not isinstance(taxable_basis, float):
                raise TypeError("taxable_basis must be float")
            if not isinstance(taxable_amount, float):
                raise TypeError("taxable_amount must be float")
            if not isinstance(gross_amount, float):
                raise TypeError("gross_amount must be float")

        self.tax_rate = tax_rate
        self.tax_category_code = tax_category_code
        self.tax_amount = tax_amount
        self.taxable_basis = taxable_basis
        self.taxable_amount = taxable_amount
        self.gross_amount = gross_amount

    def to_xml(self) -> Element:
        """Return XML Element <Tax-Summary-Line> with all tax details."""
        root = Element("Tax-Summary-Line")

        fields = {
            "TaxRate": self.tax_rate,
            "TaxCategoryCode": self.tax_category_code,
            "TaxAmount": self.tax_amount,
            "TaxableBasis": self.taxable_basis,
            "TaxableAmount": self.taxable_amount,
            "GrossAmount": self.gross_amount,
        }

        for tag, value in fields.items():
            el = SubElement(root, tag)
            el.text = str(value).strip() if value is not None else ""

        return root
