class ConvertError(Exception):
    """Error during conversion. Conversion is not possible but should be continued from the next item"""

    ...


class ILNError(ConvertError):
    """ILN is invalid or not found."""

    def __init__(self, message, nip=None):
        super().__init__(message)
        self.nip = nip


class InvoicePaymentMeansError(ConvertError):
    """Invoice payment means is invalid and cannot be converted into EDI InvoicePaymentMeans."""

    def __init__(self, message, value=None):
        super().__init__(message)
        self.value = value

    @staticmethod
    def create(value: str):
        return InvoicePaymentMeansError(
            message=f'Unsupported payment method name ("{value}") cannot be converted into `InvoicePaymentMeans`',
            value=value,
        )


class ItemTypeError(ConvertError):
    """Item type is invalid and cannot be converted into EDI ItemType."""

    def __init__(self, message):
        super().__init__(message)


class UnitOfMeasureError(ConvertError):
    """Unit of measure is invalid and cannot be converted into EDI UnitOfMeasure."""

    ...


class DocumentFunctionCodeError(ConvertError):
    """System cannot determine the correct value for the 'Document Function Code' field."""

    ...


class MissingCustomerNIP(ConvertError):
    """Customer NIP is null or empty in the document."""

    def __init__(self, message, document_number=None):
        super().__init__(message)
        self.document_number = document_number
