# nexo-pro-edi

### Installation

```bash
# Install
python -m pip install --index-url https://pip.altcomp.pl/altcomp/dev/+simple --extra-index-url https://pypi.org/simple epp_to_edi

# Run the script
epp
```

### Usage
```text
usage: main.py [-h] [-c CONFIG] [--keep-files] [-l {TRACE,DEBUG,INFO,SUCCESS,WARNING,ERROR,CRITICAL}] [-lf LOG_FILE] {run,test,watch,work,init} ...

EPP → XML converter for Nexo-Pro integration

options:
  -h, --help            show this help message and exit
  -c, --config CONFIG   Ścieżka do pliku konfiguracyjnego (domyślnie: ./config.json)
  --keep-files          Do not move input files after processing.
  -l, --log-level {TRACE,DEBUG,INFO,SUCCESS,WARNING,ERROR,CRITICAL}
                        Stopień logowania (domyślnie: INFO lub wartość z LOG_LEVEL)
  -lf, --log-file LOG_FILE
                        Ścieżka do pliku logowania (domyślnie: None)

subcommands:
  Komenda do wykonania.

  {run,test,watch,work,init}
    run                 Uruchom program.
    test                Test.
    watch               Monitoruj zmiany w folderze.
    work                Przetwarzaj zmiany w folderze w określonych interwałach.
    init                Zainicjuj folder z danymi i konfigurację.
```

### Configuration

```json5
{
  "EPP_INPUT_DIR": "/*", // .epp files source directory to scan.
  "EDI_OUTPUT_DIR": "/*",// Directory to save generated EDI files.
  "PROCESSED_DIR": "/*", // Directory to save move EPP files to.
  "GLN": "/*",           // GLN of the supplier (constant for mapping). Unused.
  "ILNs": {              // Mapping of ILNs
    "<NIP>": "<ILN>"
  },
  "DELIVERY_LOCATION_ILNs": {
    "<NIP>": "<ILN>"
  }
}
```