from userguide.models import Category
from userguide.serializers.category import PublicCategorySerializer, SimpleCategorySerializer
from userguide.views.base import BaseViewSet

from .category_filterset import CategoryFilterSet


class CategoryViewSet(BaseViewSet):
    """
    Category View set supports READ/LIST/ALL actions.
    """
    list_serializer = SimpleCategorySerializer
    read_serializer = PublicCategorySerializer
    all_serializer = SimpleCategorySerializer
    create_serializer = PublicCategorySerializer

    ordering_fields = (
        'order',
        'total_articles',
    )

    def get_queryset(self):
        return Category.objects.get_queryset() \
            .with_annotations() \
            .prefetch_related('articles')


    @property
    def filterset_class(self):
        return CategoryFilterSet