from userguide.models import Article
from userguide.serializers.article import PublicArticleSerializer
from userguide.serializers.article import SimpleArticleSerializer
from userguide.views.article.article_filterset import ArticleFilterSet
from userguide.views.base import BaseViewSet


class ArticleViewSet(BaseViewSet):
    list_serializer = SimpleArticleSerializer
    read_serializer = PublicArticleSerializer
    all_serializer = SimpleArticleSerializer

    ordering_fields = (
        'order',
        'title',
        'total_attachments',
    )

    @property
    def filterset_class(self):
        return ArticleFilterSet

    def get_queryset(self):
        return Article.objects.with_annotations() \
            .select_related("category") \
            .prefetch_related("attachments")
