from django.db.models import Q

from django_filters.rest_framework import FilterSet
from django_filters.rest_framework import CharFilter
from django_filters.rest_framework import NumberFilter

from userguide.views.filters import MultiplePKFilter


# noinspection SpellCheckingInspection
class ArticleFilterSet(FilterSet):
    title = CharFilter(field_name='title', lookup_expr='icontains')
    content = CharFilter(field_name='content', lookup_expr='icontains')
    category = MultiplePKFilter(field_name='category')
    category_group = MultiplePKFilter(field_name='category__group')

    search = CharFilter(method='search_filter')

    total_attachments_min, total_attachments_max = (
        NumberFilter(field_name='total_attachments', lookup_expr='gte'),
        NumberFilter(field_name='total_attachments', lookup_expr='lte'),
    )

    next_article_id = NumberFilter(field_name='next_article_id')
    previous_article_id = NumberFilter(field_name='previous_article_id')

    exclude = NumberFilter(field_name='id', exclude=True)

    # noinspection PyMethodMayBeStatic,PyUnusedLocal
    def search_filter(self, queryset, name, value):
        return queryset.filter(
            Q(title__icontains=value) | Q(content__icontains=value)
        )