from userguide.models import CategoryGroup
from userguide.serializers.base import PublicSerializer

from rest_framework.serializers import IntegerField

from .very_simple_category_serializer import VerySimpleCategorySerializer


class PublicCategoryGroupSerializer(PublicSerializer):
    total_categories = IntegerField(
        read_only=True,
        allow_null=True,
    )

    total_articles = IntegerField(
        read_only=True,
        allow_null=True,
    )

    categories = VerySimpleCategorySerializer(many=True, read_only=True)

    class Meta:
        model = CategoryGroup
        fields = ('title', 'order', 'total_categories', 'categories', 'description', 'icon', 'total_articles',)
