from userguide.models import Category
from userguide.serializers.base import PublicSerializer
from userguide.serializers.base import TruncateCharField

from rest_framework.serializers import IntegerField

from .very_simple_article_serializer import VerySimpleArticleSerializer

class SimpleCategorySerializer(PublicSerializer):
    """
    Serializer for handling simple category representations.

    This class is used to serialize `Category` objects into a format with limited
    content length, ensuring content does not exceed a predefined size for display
    or transmission purposes.
    """

    total_articles = IntegerField(
        read_only=True,
        allow_null=True,
    )

    first_article_id = IntegerField(
        read_only=True,
        allow_null=True,
    )

    articles = VerySimpleArticleSerializer(many=True, read_only=True)

    content = TruncateCharField()

    class Meta:
        model = Category
        fields = (
            'title',
            'content',
            'total_articles',
            'order',
            'image',
            'first_article_id',
            'articles',
            'group_id',
        )