from userguide.models import Category

from userguide.serializers.base import PublicSerializer

from rest_framework.serializers import IntegerField

from .very_simple_article_serializer import VerySimpleArticleSerializer

class PublicCategorySerializer(PublicSerializer):
    total_articles = IntegerField(
        read_only=True,
        allow_null=True,
    )

    first_article_id = IntegerField(
        read_only=True,
        allow_null=True,
    )

    articles = VerySimpleArticleSerializer(many=True, read_only=True)

    class Meta:
        model = Category
        fields = (
            'title',
            'content',
            'total_articles',
            'order',
            'image',
            'first_article_id',
            'articles',
            'group_id',
        )