from rest_framework.serializers import ModelSerializer
from rest_framework.serializers import IntegerField
from rest_framework.serializers import DateTimeField
from rest_framework.serializers import CharField

from django.conf import settings

class TruncateCharField(CharField):
    def __init__(
        self,
        length=settings.USER_GUIDE_STRING_TRUNCATE_LENGTH,
        **kwargs
    ):
        self.length = length
        super().__init__(**kwargs)

    def to_representation(self, value):
        if value is None:
            return None

        if not isinstance(value, str):
            raise ValueError(
                'Value must be a string.'
            )

        if len(value) <= self.length:
            return value

        return value[:self.length] + '...'

# noinspection PyUnresolvedReferences
class PublicSerializer(ModelSerializer):
    """
    Provides a serializer that adds default fields `id`, `created`, and `updated`
    to the serialized output. This serializer is intended to be used for exposing
    public-facing representations of data models. It inherits from `ModelSerializer`
    and modifies the default fields.

    Attributes:
        id (int)
        created (datetime)
        updated (datetime)
    """

    def get_fields(self):
        fields = super().get_fields()
        fields['id'] = IntegerField(read_only=True)
        fields['created'] = DateTimeField(read_only=True)
        fields['updated'] = DateTimeField(read_only=True)
        return fields