from userguide.models import Article
from userguide.serializers.base import PublicSerializer
from userguide.serializers.category import SimpleCategorySerializer

from rest_framework.serializers import IntegerField

from .attachment import PublicArticleAttachmentSerializer

class PublicArticleSerializer(
    PublicSerializer,
):
    """
    Serializes the public data of an article.

    This serializer is used to represent the public-facing data of an article,
    including its title, content, and category. It is based on the `Article` model
    and uses the `SimpleCategorySerializer` for read-only representation of the
    category attribute.
    """
    category = SimpleCategorySerializer(read_only=True)
    attachments = PublicArticleAttachmentSerializer(many=True, read_only=True)
    total_attachments = IntegerField(read_only=True, allow_null=True)

    next_article_id = IntegerField(read_only=True, allow_null=True)
    previous_article_id = IntegerField(read_only=True, allow_null=True)

    class Meta:
        model = Article
        fields = (
            'title',
            'content',
            'category',
            'order',
            'attachments',
            'total_attachments',
            'next_article_id',
            'previous_article_id',
        )