from django.db.models import QuerySet
from django.db.models import Count

from typing import Self


class CategoryGroupQuerySet(QuerySet):
    """
    Category Group QuerySet
    """
    def with_total_categories(self) -> Self:
        """
        Add `total_categories=int` field to queryset
        """
        return self.annotate(
            total_categories=Count('categories'),
        )

    def with_total_articles(self) -> Self:
        """
        Add total_articles field to queryset
        """
        return self.annotate(
            total_articles=Count('categories__articles'),
        )

    def with_annotations(self) -> Self:
        """
        Applies with_total_categories method to queryset
        :return:
        """
        return self \
            .with_total_categories() \
            .with_total_articles()