from django.db.models import Manager

from .category_queryset import CategoryQuerySet

class CategoryManager(Manager):
    """
    Manages database queries for the Category model.

    This class extends the capabilities of the `Manager` class in Django, enabling
    custom query sets and database operations tailored for the `Category` model.
    """

    def get_queryset(self) -> CategoryQuerySet:
        return CategoryQuerySet(self.model, using=self._db)
