from django.db.models import Count
from django.db.models import QuerySet
from django.db.models import Subquery
from django.db.models import OuterRef


class ArticleQuerySet(QuerySet):
    """
    Article QuerySet
    """

    def with_total_attachments(self):
        return self.annotate(
            total_attachments=Count('attachments', distinct=True),
        )

    def with_next_article_id(self):
        return self.annotate(
            next_article_id=Subquery(
                self.model.objects.exclude(id=OuterRef('id'))
                .filter(category=OuterRef('category'))
                .filter(order__gt=OuterRef('order'))
                .order_by('order')
                .values('id')[:1]
            )
        )

    def with_previous_article_id(self):
        return self.annotate(
            previous_article_id=Subquery(
                self.model.objects.exclude(id=OuterRef('id'))
                .filter(category=OuterRef('category'))
                .filter(order__lt=OuterRef('order'))
                .order_by('-order')
                .values('id')[:1]
            )
        )

    def with_annotations(self):
        return self \
            .with_total_attachments() \
            .with_next_article_id() \
            .with_previous_article_id()