from django.conf import settings
from django.urls import path
from django.urls import include

from rest_framework.routers import DefaultRouter
from rest_framework.routers import SimpleRouter

from table.api.views import TableViewSet
from table.api.views import TableConfigurationViewSet

def _get_router():
    r = DefaultRouter() if settings.DEBUG else SimpleRouter()
    r.register(r'table', TableViewSet, basename='table')
    r.register(r'table-configuration', TableConfigurationViewSet, basename='table-configuration')
    return r

router = _get_router()

urlpatterns = [
    path('', include(router.urls)),
]