from django.conf import settings

from django.db.models import CharField
from django.db.models import ManyToManyField

from table.models.base import BaseModel

class Table(BaseModel):
    """
    Table definition

    Attributes:
        title (CharField | null):
            Visible title to display in the Django Admin Site.
            Nullable field does not really matter.

        key (CharField):
            A table key must be unique.
            Key will be used as Primary Key, allows retrieving table data by key.

        configs (ManyToManyField<TableConfig>):
            List of table configs related to this table.
            This is a many-to-many relation through table.TableConfiguration model.
    """
    title = CharField(max_length=128, null=True)

    key = CharField(max_length=128, unique=True)

    configs = ManyToManyField(
        through='table.TableConfiguration',
        to=settings.AUTH_USER_MODEL,
        related_name='tables',
    )

    def __str__(self) -> str:
        title = self.title if self.title else ''
        return f'{title} ({self.key})'
