from django.db.models import BigAutoField
from django.db.models import DateTimeField
from django.db.models import Model

from django.utils.translation import gettext_lazy as _

class BaseModel(Model):
    """
    Base model.

    Attributes:
        id (BigAutoField): Primary key.
        created (DateTimeField): "Created at" date time.
        updated (DateTimeField): "Updated at" time.
    """
    id = BigAutoField(primary_key=True)
    created = DateTimeField(auto_now_add=True, verbose_name=_('Created at'))
    updated = DateTimeField(auto_now=True, verbose_name=_('Updated at'))

    class Meta:
        ordering = ['-created']
        abstract = True
