# Generated by Django 5.2.7 on 2025-10-16 10:32

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Table',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('title', models.CharField(max_length=128, null=True)),
                ('key', models.CharField(max_length=128, unique=True)),
            ],
            options={
                'ordering': ['-created'],
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TableConfiguration',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('updated', models.DateTimeField(auto_now=True, verbose_name='Updated at')),
                ('sort_field', models.CharField(max_length=128, null=True)),
                ('sort_direction', models.CharField(choices=[('asc', 'Asc'), ('desc', 'Desc')], max_length=128, null=True)),
                ('visible_columns', models.JSONField(default=None, null=True)),
                ('columns_order', models.JSONField(default=None, null=True)),
                ('table', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='table_configs', to='table.table')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='table_configs', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['-created'],
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='table',
            name='configs',
            field=models.ManyToManyField(related_name='tables', through='table.TableConfiguration', to=settings.AUTH_USER_MODEL),
        ),
    ]
