from django.db.models import QuerySet

from table.api.serializers import TableSerializer
from table.api.views.base import BaseViewSet
from table.models import Table

from typing import Type

class TableViewSet(BaseViewSet):
    """
    ViewSet for accessing Table data.
    """
    lookup_field = 'key'

    def get_serializer_class(self) -> Type[TableSerializer]:
        """
        Retrieves the serializer class used for serializing Table instances.
        """
        return TableSerializer

    def get_queryset(self) -> QuerySet[Table]:
        """
        Retrieves and returns the queryset for the Table model.

        Returns
        -------
        QuerySet
            A QuerySet for the Table model containing all objects.
        """
        return Table.objects.get_queryset()