# django-table

A lightweight Django app for persisting and retrieving per-user table configurations. It stores user preferences (like visible columns, order, sorting, and page size) in the database and provides a simple interface to load and apply them across views, so user settings are remembered between sessions.

Use cases:
- Remember individual users’ table layouts across pages and logins
- Provide a consistent data table experience without relying on browser storage
- Centralize table preferences for auditing and portability

Models (overview):
- Table: Represents a logical table within your application (e.g., “Orders” or “Users”), identified by a unique key and optional metadata.
- TablePreference: Stores a single user’s preferences for a specific Table, such as selected columns, sort order, filters, and pagination settings.


### Developing

```bash
# Running tests
# ------------------------
python manage.py test
```