# Example Package

A simple Python package for testing private pip repositories.

## Features

- **Calculator**: Basic mathematical operations (add, subtract, multiply, divide)
- **TextProcessor**: Text utilities (clean, count words, reverse, extract numbers, title case)

## Installation

```bash
pip install example-package
```

## Usage

### Calculator

```python
from example_package import Calculator

calc = Calculator()
result = calc.add(5, 3)  # 8
result = calc.multiply(4, 6)  # 24
print(calc.get_history())
```

### TextProcessor

```python
from example_package import TextProcessor

processor = TextProcessor()
text = "  Hello   World 123  "
cleaned = processor.clean_text(text)  # "Hello World 123"
word_count = processor.count_words(cleaned)  # 3
numbers = processor.extract_numbers(text)  # ["123"]
```

## Development

### Setup

```bash
git clone <repository-url>
cd example-package
pip install -e ".[dev]"
```

### Running Tests

```bash
pytest
```

### Code Formatting

```bash
black src/ tests/
```

## License

MIT License
