from os.path import join, dirname
from app.domain.epp.parser import parse_epp, EPP
from tests.fixtures import File
from tests.fixtures import read_test_file

with open(join(dirname(__file__), "test.epp")) as f:
    TEST_STRING = f.read()


def test_parse_returns_instance_of_epp_class():
    r = parse_epp(TEST_STRING)
    assert isinstance(r, EPP), "Expected result to be a dict"


def test_parse_returns_info_as_instance_of_list():
    r = parse_epp(TEST_STRING)
    assert isinstance(r.info, list), "Expected result to be a list"


def test_parse_returns_expected_length_of_the_info():
    r = parse_epp(TEST_STRING)
    assert len(r.info) == 24


def test_parse_returns_expected_length_of_the_headers():
    r = parse_epp(TEST_STRING)
    assert len(r.headers) == 13


def test_parse_returns_ints():
    r = parse_epp(TEST_STRING)
    assert r.info[1] == 3


def test_parse_returns_floats():
    r = parse_epp(TEST_STRING)
    assert r.headers["CENNIK"][0][2] == 150.0


def test_parse_returns_expected_headers():
    r = parse_epp(TEST_STRING)
    assert len(r.headers["DOKUMENTYFISKALNEVAT"]) == 1  # number of items in content
    assert (
        len(r.headers["DOKUMENTYFISKALNEVAT"][0]) == 2  # number of columns in content
    )


def test_parse_returns_list_header_if_not_a_string():
    r = parse_epp(TEST_STRING)
    r = r.get_header()
    assert r[0] == "FS", "Expected first item of the `get_header()` to be `FS`"


def test_parse_does_not_throw_if_file_contains_many_documents():
    file_content = read_test_file(File.MANY, encoding="cp1250")
    _ = parse_epp(file_content)


_str = """
[NAGLOWEK]
"TOWARY"

[ZAWARTOSC]
1,"AZE-231","AZE-231","5906745698166","Ta�ma do drukarki 12mm AZE-231 CZAR-BIA�Y","Ta�ma do drukarki 12mm B-SERIES, czarny wydruk na bia�ym tle TZE","Ta�ma do drukarki 12mm AZE-231",,,"szt","23",23.0000,"23",23.0000,12.2900,12.2900,"szt",0,"PLN",,"szt",0.0000,60.0000,"739",,0,,0.0000,0.0000,,0,,0,0,,,,,,,,"""


def test_parse_parses_csv_rows_with_new_lines():
    epp = parse_epp(_str)
    assert epp.headers.get("TOWARY")[0].__len__() == 42


def test_parse_parses_csv_rows_with_new_lines_correctly():
    epp = parse_epp(_str)
    assert epp.headers.get("TOWARY")[0][-1] is None
