import pytest

from app.domain.epp.models import LineItem
from app.domain.epp.parser import parse_epp
from tests.fixtures import File
from tests.fixtures import read_test_file


@pytest.fixture
def content() -> str:
    """Read the test file."""
    return read_test_file(File.FILE_0)


@pytest.mark.usefixtures("content")
def test_from_csv_returns_instance_of_line_item_class(content: str):
    epp = parse_epp(content)
    content = epp.headers.get(epp.get_header())
    r = LineItem.from_csv(content[0])
    assert isinstance(r, LineItem), 'Expected result to be an instance of "LineItem"'


# noinspection DuplicatedCode
@pytest.mark.usefixtures("content")
def test_from_csv_returns_expected_values(content: str):
    epp = parse_epp(content)
    content = epp.headers.get(epp.get_header())

    # --- first line item ---
    r = LineItem.from_csv(content[0])
    assert r.position_number == 1
    assert r.item_type == 1
    assert r.item_code == "Z-50 DIN"
    assert r.discount_is_percent == 1
    assert r.discount_from_price == 1
    assert r.discount_cumulative == 0
    assert r.discount_locked == 0
    assert r.discount_value == 0.0
    assert r.discount_percent == 0.0
    assert r.unit == "szt"
    assert r.quantity_in_unit == 1.0
    assert r.quantity_in_stock_unit == 1.0
    assert r.warehouse_price == 301.0
    assert r.net_price == 121.14
    assert r.gross_price == 149.0
    assert r.vat_rate_percent == 23.0
    assert r.net_value == 121.14
    assert r.vat_value == 27.86
    assert r.gross_value == 149.0
    assert r.cost_value == 301.0
    assert (
        isinstance(r.one_time_service_description, str)
        and r.one_time_service_description[:10] != ""
    )
    assert r.one_time_service_name is None

    # --- second line item ---
    r2 = LineItem.from_csv(content[1])
    assert r2.position_number == 2
    assert r2.item_type == 1
    assert r2.item_code == "P2-30JC"
    assert r2.discount_is_percent == 1
    assert r2.discount_from_price == 1
    assert r2.discount_cumulative == 0
    assert r2.discount_locked == 0
    assert r2.discount_value == 0.0
    assert r2.discount_percent == 0.0
    assert r2.unit == "szt"
    assert r2.quantity_in_unit == 1.0
    assert r2.quantity_in_stock_unit == 1.0
    assert r2.warehouse_price == 35.9
    assert r2.net_price == 80.49
    assert r2.gross_price == 99.0
    assert r2.vat_rate_percent == 23.0
    assert r2.net_value == 80.49
    assert r2.vat_value == 18.51
    assert r2.gross_value == 99.0
    assert r2.cost_value == 35.9
    assert (
        isinstance(r2.one_time_service_description, str)
        and r2.one_time_service_description[:10] != ""
    )
    assert r2.one_time_service_name is None
