from datetime import date
from app.domain.epp.models import DocumentHeader

TEST_STRING = '"FS",1,0,2369,,,"2369/MAG/10/2025",,,,,"99819","Sklep monopolowy Irmina Brandys, PHU Tec","Sklep monopolowy Irmina Brandys, PHU Techbud Irmina Brandys","Tychy","43-100","Pi�sudskiego 62","6461768707","Sprzeda�",,"Katowice",20251023000000,20251023000000,,2,0,"Podstawowy",201.6300,46.3700,248.0000,336.9000,,0.0000,,,0.0000,248.0000,0,0,1,0,"Paulina;Czarnota",";",,0.0000,0.0000,"PLN",1.0000,"294353129 * allegro(20029) * Client:41751293 *  * Allegro One Kurier - dostawa jutro * allegro * 9ebceb60-afe8-11f0-bf04-8b76d82e6a9f",,,,0,0,0,,0.0000,,0.0000,"Polska","PL",0'


def get_row():
    import csv

    reader = csv.reader([TEST_STRING], delimiter=",")
    return list(reader)[0]


def test_returns_instance_of_document_header():
    r = DocumentHeader.from_csv(get_row())
    assert isinstance(
        r, DocumentHeader
    ), "Expected result to be an instance of DocumentHeader"


# noinspection DuplicatedCode
def test_returns_expected_values():
    r = DocumentHeader.from_csv(get_row())
    assert r.doc_type == "FS"
    assert r.status == 1
    assert r.fiscal_registration_status == 0
    assert r.document_number == 2369
    assert r.full_document_number == "2369/MAG/10/2025"
    assert r.place_of_issue == "Katowice"
    assert r.issue_date == date(2025, 10, 23)
    assert r.sale_date == date(2025, 10, 23)
    assert r.number_of_items == 2
    assert r.net_price_document is False
    assert r.active_price_name == "Podstawowy"
    assert r.net_value == 201.63
    assert r.vat_value == 46.37
    assert r.gross_value == 248.0
    assert r.cost_value == 336.9
    assert r.discount_percent == 0.0
    assert r.amount_paid_on_delivery == 0.0
    assert r.amount_due == 248.0
    assert r.rounding_unit == 0
    assert r.rounding_vat == 0
    assert r.auto_vat_table_calc is True
    assert r.extended_statuses == 0
