from app.infra.application import run_app
from app.infra.logging import configure_logger
from app.infra.parser import parse_args


# def process_one_file(epp_file: Path, config: Config):
#     try:
#         file_processor = FileProcessor(config)
#         file_processor.process_file(epp_file)
#         logger.success(f"OK {epp_file.absolute()}")
#     except ConvertError as e:
#         logger.error(f"Could not process file: {e}")
#
#
# def run(config: Config, parser_args) -> int:
#     """Run program at returns the status code."""
#     p = config.input_dir
#     epp_files = [f for f in p.iterdir() if f.is_file() and f.suffix == ".epp"]
#     logger.debug(f"Found {len(epp_files)} EPP files.")
#
#     for epp_file in epp_files:
#         process_one_file(epp_file, config)
#
#     if parser_args.command == "watch":
#         logger.info("Watching for new files...")
#         for changes in watch(Path(config.input_dir), recursive=False):
#             for change, path in changes:
#                 if change == Change.added:
#                     if not Path(path).is_file():
#                         continue
#                     if not Path(path).suffix == ".epp":
#                         logger.warning(f"File {path.title()} is not an EPP file.")
#                         continue
#                     logger.debug(f"File {path.title()} detected.")
#                     process_one_file(Path(path), config)
#     return 0


def main():
    args = parse_args()
    configure_logger(level=args.log_level, log_file=args.log_file)
    _res = run_app()

    import sys

    sys.exit(_res)


if __name__ == "__main__":
    main()
