from dataclasses import dataclass
from pathlib import Path

from app.domain.config import Config
from app.infra.file_processor import FileProcessor
from app.infra.parser import Args

@dataclass
class Result:
    total_files: int

class DataProcessor:
    def __init__(self, config: Config, args: Args, file_processor: FileProcessor):
        self.config = config
        self.args = args
        self.file_processor = file_processor

    def _get_files(self) -> list[Path]:
        """ Get all EPP files to process. """
        p = Path(self.config.input_dir)
        return [f for f in p.iterdir() if f.is_file() and f.suffix == ".epp"]

    def process(self) -> Result:
        """Run program at returns the result."""
        files = self._get_files()
        for epp_file in files:
            self.file_processor.process_file(epp_file)
        return Result(total_files=len(files))