from app.domain.config import Config


class ConfigSerializer:

    @staticmethod
    def serialize(config: Config) -> dict:
        """
        Serialize config to dict. May create a broken config, with absolute paths, etc.
        :param config:
        :return: dict
        """
        return {
            "EPP_INPUT_DIR": config.input_dir,
            "EDI_OUTPUT_DIR": config.output_dir,
            "PROCESSED_DIR": config.processed_dir,
            "GLN": config.gln,
            "ILNs": config.ilns,
            "DELIVERY_LOCATION_ILNs": config.delivery_location_ilns,
        }