from datetime import datetime, date


def parse_date_or_null(epp_date: str | int) -> date | None:
    # noinspection SpellCheckingInspection
    """
    Convert EPP datetime format (YYYYMMDDHHMMSS) to datetime.date.
    Returns None if the input is empty or invalid.
    """
    if not epp_date:
        return None
    if isinstance(epp_date, int):
        epp_date = str(epp_date)
    if not epp_date.strip():
        return None
    try:
        return datetime.strptime(epp_date.strip(), "%Y%m%d%H%M%S").date()
    except ValueError:
        return None
