class PriceListItem:
    """
    Represents an item entry from the goods price list.

    Attributes
    ----------
    item_id : str
        (1) Kod identyfikacyjny towaru – item identification code.
    price_name : str
        (2) Nazwa ceny – name of the price.
    net_price : float
        (3) Cena netto – net price.
    gross_price : float
        (4) Cena brutto – gross price.
    markup_percent : float
        (5) Narzut w procentach – markup percentage.
    margin_percent : float
        (6) Marża w procentach – margin percentage.
    profit : float
        (7) Zysk – profit amount.
    """

    def __init__(
        self,
        item_id: str,
        price_name: str,
        net_price: float,
        gross_price: float,
        markup_percent: float,
        margin_percent: float,
        profit: float,
    ):
        self.item_id = item_id
        self.price_name = price_name
        self.net_price = net_price
        self.gross_price = gross_price
        self.markup_percent = markup_percent
        self.margin_percent = margin_percent
        self.profit = profit

    @staticmethod
    def from_csv(csv_row: list) -> "PriceListItem":
        return PriceListItem(
            item_id=csv_row[0],
            price_name=csv_row[1],
            net_price=csv_row[2],
            gross_price=csv_row[3],
            markup_percent=csv_row[4],
            margin_percent=csv_row[5],
            profit=csv_row[6],
        )
