class Item:
    """
    Represents a document item in the document.
    From the [TOWARY] section.

    Attributes
    ----------
    item_type : int
        (1) Typ towaru – type of item (1 - goods, 2 - service, 4 - packaging, 8 - set, 16 - additional fee).
    item_id : str
        (2) Kod identyfikacyjny – identification code.
    supplier_code : str
        (3) Kod towaru u producenta / dostawcy – supplier or manufacturer code.
    barcode : str
        (4) Kod paskowy – barcode.
    name : str
        (5) Nazwa – name of the item.
    description : str
        (6) Opis – description (up to 255 chars).
    fiscal_device_name : str
        (7) Nazwa towaru dla urządzeń fiskalnych – name for fiscal printers.
    sww_symbol : str
        (8) Symbol SWW lub KU – SWW or KU code.
    pkwiu_symbol : str
        (9) Symbol PKWiU – Polish Classification of Goods and Services.
    base_unit : str
        (10) Podstawowa jednostka miary – base unit of measure.
    vat_symbol : str
        (11) Symbol stawki podatku VAT – VAT rate symbol.
    vat_rate : float
        (12) Wysokość stawki podatku VAT w procentach – VAT rate percentage.
    vat_purchase_symbol : str
        (13) Symbol stawki podatku VAT przy zakupie – VAT rate symbol for purchase.
    vat_purchase_rate : float
        (14) Wysokość stawki podatku VAT przy zakupie w procentach – VAT rate % for purchase.
    last_net_purchase_price : float
        (15) Ostatnia cena zakupu netto (w PLN) – last net purchase price (PLN).
    foreign_purchase_price : float
        (16) Cena zakupu walutowa – purchase price in foreign currency.
    purchase_unit : str
        (17) Jednostka miary przy zakupie – unit used for purchase.
    currency_rate_unit : int
        (18) Kurs waluty służący do kalkulacji ceny zakupu – exchange rate unit (byte).
    currency_symbol : str
        (19) Symbol waluty – currency symbol.
    packaging_code : str
        (20) Kod opakowania związanego z towarem – packaging code.
    minimal_unit : str
        (21) Jednostka miary dla stanu minimalnego – unit for minimal stock level.
    minimal_stock : float
        (22) Stan minimalny (wybrana jednostka) – minimal stock level (quantity).
    lead_time_days : int
        (23) Średni czas realizacji dostawy – average delivery lead time (days).
    supplier_id : str
        (24) Kod identyfikacyjny producenta / dostawcy – supplier ID.
    expiry_date : str
        (25) Data ważności jako konkretny dzień – expiration date.
    expiry_days : int
        (26) Data ważności jako ilość dni od ostatniej dostawy – days until expiry from last delivery.
    volume_unit : str
        (27) Jednostka miary dla objętości – volume unit of measure.
    volume_value : float
        (28) Objętość towaru (wybrana jednostka) – volume of the item (in selected unit).
    labor_hours : float
        (29) Ilość roboczo-godzin w jednostce podstawowej usługi – labor hours per basic unit.
    labor_type : str
        (30) Rodzaj roboczo-godzin usługi – type of labor hours.
    is_open_price : bool
        (31) Cena otwarta – whether item has open price (boolean).
    notes : str
        (32) Uwagi – notes or remarks.
    pricing_basis : int
        (33) Podstawa kalkulacji cen – price calculation basis (0 - markup, 1 - margin, 2 - profit).
    is_weighted : bool
        (34) Towar ważony na wadze etykietującej – item sold by weight with labeling scale (boolean).
    user_field_1 : str
        (35) Pole użytkownika 1 – user-defined field 1.
    user_field_2 : str
        (36) Pole użytkownika 2 – user-defined field 2.
    user_field_3 : str
        (37) Pole użytkownika 3 – user-defined field 3.
    user_field_4 : str
        (38) Pole użytkownika 4 – user-defined field 4.
    user_field_5 : str
        (39) Pole użytkownika 5 – user-defined field 5.
    user_field_6 : str
        (40) Pole użytkownika 6 – user-defined field 6.
    user_field_7 : str
        (41) Pole użytkownika 7 – user-defined field 7.
    user_field_8 : str
        (42) Pole użytkownika 8 – user-defined field 8.
    """

    def __init__(
        self,
        item_type: int,
        item_id: str,
        supplier_code: str,
        barcode: str,
        name: str,
        description: str,
        fiscal_device_name: str,
        sww_symbol: str,
        pkwiu_symbol: str,
        base_unit: str,
        vat_symbol: str,
        vat_rate: float,
        vat_purchase_symbol: str,
        vat_purchase_rate: float,
        last_net_purchase_price: float,
        foreign_purchase_price: float,
        purchase_unit: str,
        currency_rate_unit: int,
        currency_symbol: str,
        packaging_code: str,
        minimal_unit: str,
        minimal_stock: float,
        lead_time_days: int,
        supplier_id: str,
        expiry_date: str,
        expiry_days: int,
        volume_unit: str,
        volume_value: float,
        labor_hours: float,
        labor_type: str,
        is_open_price: bool,
        notes: str,
        pricing_basis: int,
        is_weighted: bool,
        user_field_1: str,
        user_field_2: str,
        user_field_3: str,
        user_field_4: str,
        user_field_5: str,
        user_field_6: str,
        user_field_7: str,
        user_field_8: str,
    ):
        self.item_type = item_type
        self.item_id = item_id
        self.supplier_code = supplier_code
        self.barcode = barcode
        self.name = name
        self.description = description
        self.fiscal_device_name = fiscal_device_name
        self.sww_symbol = sww_symbol
        self.pkwiu_symbol = pkwiu_symbol
        self.base_unit = base_unit
        self.vat_symbol = vat_symbol
        self.vat_rate = vat_rate
        self.vat_purchase_symbol = vat_purchase_symbol
        self.vat_purchase_rate = vat_purchase_rate
        self.last_net_purchase_price = last_net_purchase_price
        self.foreign_purchase_price = foreign_purchase_price
        self.purchase_unit = purchase_unit
        self.currency_rate_unit = currency_rate_unit
        self.currency_symbol = currency_symbol
        self.packaging_code = packaging_code
        self.minimal_unit = minimal_unit
        self.minimal_stock = minimal_stock
        self.lead_time_days = lead_time_days
        self.supplier_id = supplier_id
        self.expiry_date = expiry_date
        self.expiry_days = expiry_days
        self.volume_unit = volume_unit
        self.volume_value = volume_value
        self.labor_hours = labor_hours
        self.labor_type = labor_type
        self.is_open_price = is_open_price
        self.notes = notes
        self.pricing_basis = pricing_basis
        self.is_weighted = is_weighted
        self.user_field_1 = user_field_1
        self.user_field_2 = user_field_2
        self.user_field_3 = user_field_3
        self.user_field_4 = user_field_4
        self.user_field_5 = user_field_5
        self.user_field_6 = user_field_6
        self.user_field_7 = user_field_7
        self.user_field_8 = user_field_8

    def __str__(self):
        """Get string representation of the object."""
        return f"{self.barcode}: {self.name}: {self.description}"

    @staticmethod
    def from_csv(csv_row) -> "Item":
        return Item(
            item_type=csv_row[0],
            item_id=csv_row[1],
            supplier_code=csv_row[2],
            barcode=csv_row[3],
            name=csv_row[4],
            description=csv_row[5],
            fiscal_device_name=csv_row[6],
            sww_symbol=csv_row[7],
            pkwiu_symbol=csv_row[8],
            base_unit=csv_row[9],
            vat_symbol=csv_row[10],
            vat_rate=csv_row[11],
            vat_purchase_symbol=csv_row[12],
            vat_purchase_rate=csv_row[13],
            last_net_purchase_price=csv_row[14],
            foreign_purchase_price=csv_row[15],
            purchase_unit=csv_row[16],
            currency_rate_unit=csv_row[17],
            currency_symbol=csv_row[18],
            packaging_code=csv_row[19],
            minimal_unit=csv_row[20],
            minimal_stock=csv_row[21],
            lead_time_days=csv_row[22],
            supplier_id=csv_row[23],
            expiry_date=csv_row[24],
            expiry_days=csv_row[25],
            volume_unit=csv_row[26],
            volume_value=csv_row[27],
            labor_hours=csv_row[28],
            labor_type=csv_row[29],
            is_open_price=csv_row[30],
            notes=csv_row[31],
            pricing_basis=csv_row[32],
            is_weighted=csv_row[33],
            user_field_1=csv_row[34],
            user_field_2=csv_row[35],
            user_field_3=csv_row[36],
            user_field_4=csv_row[37],
            user_field_5=csv_row[38],
            user_field_6=csv_row[39],
            user_field_7=csv_row[40],
            user_field_8=csv_row[41],
        )
