class Header:
    """
    Represents the header structure for the communication file.
    From the [INFO] section.

    Attributes
    ----------
    edi_file_version : str
        (1) Wersja formatu pliku EDI++ – EDI file format version.
    communication_purpose : int
        (2) Cel komunikacji – Purpose of communication
        (0 - accounting office, 1 - acquirer, 2 - headquarters, 3 - other).
    encoding_page : str
        (3) Strona kodowa zapisu – Encoding page (e.g. 852 - Latin 2).
    program_info : str
        (4) Informacja o programie – Name of the software creating the file.
    sender_code : str
        (5) Kod identyfikacyjny nadawcy pliku komunikacji – Sender identification code.
    sender_short_name : str
        (6) Nazwa skrócona nadawcy – Short name of sender.
    sender_long_name : str
        (7) Nazwa długa nadawcy – Full name of sender.
    sender_city : str
        (8) Miasto nadawcy – City of sender.
    sender_postal_code : str
        (9) Kod pocztowy nadawcy – Postal code of sender.
    sender_address : str
        (10) Ulica i nr nadawcy (adres) – Address of sender.
    sender_nip : str
        (11) NIP nadawcy – Tax Identification Number (NIP) of sender.
    warehouse_code : str
        (12) Kod magazynu – Warehouse code (only first 3 chars significant for InsERT GT).
    warehouse_name : str
        (13) Nazwa magazynu – Warehouse name.
    warehouse_description : str
        (14) Opis magazynu – Warehouse description.
    warehouse_analytics : str
        (15) Analityka magazynu – Warehouse analytics.
    data_period : str
        (16) Dane z okresu (następujące daty są istotne) – Data period label.
    period_start : str
        (17) Początek okresu, z którego pochodzą dane – Start date of period.
    period_end : str
        (18) Koniec okresu, z którego pochodzą dane – End date of period.
    communication_author : str
        (19) Kto wykonał komunikację – Author of communication.
    communication_date : str
        (20) Kiedy została wykonana komunikacja – Date when communication was performed.
    country : str
        (21) Państwo – Country.
    eu_country_prefix : str
        (22) Prefiks państwa UE – EU country prefix.
    eu_sender_nip : str
        (23) NIP unijny nadawcy – EU VAT number of sender.
    is_eu_sender : bool
        (24) Czy nadawca jest unijny – Indicates if sender is from EU.
    """

    def __init__(
        self,
        edi_file_version: str,
        communication_purpose: int,
        encoding_page: str,
        program_info: str,
        sender_code: str,
        sender_short_name: str,
        sender_long_name: str,
        sender_city: str,
        sender_postal_code: str,
        sender_address: str,
        sender_nip: int,
        warehouse_code: str,
        warehouse_name: str,
        warehouse_description: str,
        warehouse_analytics: str,
        data_period: str,
        period_start: str,
        period_end: str,
        communication_author: str,
        communication_date: str,
        country: str,
        eu_country_prefix: str,
        eu_sender_nip: str,
        is_eu_sender: bool,
    ):
        self.edi_file_version = edi_file_version
        self.communication_purpose = communication_purpose
        self.encoding_page = encoding_page
        self.program_info = program_info
        self.sender_code = sender_code
        self.sender_short_name = sender_short_name
        self.sender_long_name = sender_long_name
        self.sender_city = sender_city
        self.sender_postal_code = sender_postal_code
        self.sender_address = sender_address
        self.sender_nip = sender_nip
        self.warehouse_code = warehouse_code
        self.warehouse_name = warehouse_name
        self.warehouse_description = warehouse_description
        self.warehouse_analytics = warehouse_analytics
        self.data_period = data_period
        self.period_start = period_start
        self.period_end = period_end
        self.communication_author = communication_author
        self.communication_date = communication_date
        self.country = country
        self.eu_country_prefix = eu_country_prefix
        self.eu_sender_nip = eu_sender_nip
        self.is_eu_sender = is_eu_sender

    @staticmethod
    def from_csv(csv_row):
        return Header(
            edi_file_version=csv_row[0],
            communication_purpose=int(csv_row[1]),
            encoding_page=csv_row[2],
            program_info=csv_row[3],
            sender_code=csv_row[4],
            sender_short_name=csv_row[5],
            sender_long_name=csv_row[6],
            sender_city=csv_row[7],
            sender_postal_code=csv_row[8],
            sender_address=csv_row[9],
            sender_nip=csv_row[10],
            warehouse_code=csv_row[11],
            warehouse_name=csv_row[12],
            warehouse_description=csv_row[13],
            warehouse_analytics=csv_row[14],
            data_period=csv_row[15],
            period_start=csv_row[16],
            period_end=csv_row[17],
            communication_author=csv_row[18],
            communication_date=csv_row[19],
            country=csv_row[20],
            eu_country_prefix=csv_row[21],
            eu_sender_nip=csv_row[22],
            is_eu_sender=bool(int(csv_row[23])),
        )
