class Contractor:
    # noinspection SpellCheckingInspection
    """
    Represents a contractor (counterparty).
    From section: [KONTRAHENCI]

    Attributes
    ----------
    contractor_type : int
        (1) Typ kontrahenta – contractor type (0–9).
    identifier_code : str
        (2) Kod identyfikacyjny kontrahenta – unique contractor code.
    short_name : str
        (3) Nazwa skrócona – short name.
    full_name : str
        (4) Nazwa pełna – full name.
    city : str
        (5) Miasto – city.
    postal_code : str
        (6) Kod pocztowy – postal code.
    address_line : str
        (7) Ulica i numer (adres) – street and building number.
    tax_id : str
        (8) NIP kontrahenta – VAT ID.
    regon : str
        (9) REGON – business registry number.
    phone : str
        (10) Telefon – phone number.
    fax : str
        (11) Faks – fax number.
    email : str
        (13) Adres poczty elektronicznej – email address.

    bank_name : str
        (26) Nazwa banku (z podstawowego rachunku bankowego kontrahenta)
    bank_account_number : str
        (27) Numer konta bankowego (z podstawowego rachunku bankowego kontrahenta)

    country : str
        (28) Państwo kontrahenta - country.

    ue_country_prefix : str
        (29) Prefiks państwa UE kontrahenta - UE country prefix.
    """

    def __init__(
        self,
        contractor_type: int,
        identifier_code: str,
        short_name: str = "",
        full_name: str = "",
        city: str = "",
        postal_code: str = "",
        address_line: str = "",
        tax_id: str = "",
        regon: str = "",
        phone: str = "",
        fax: str = "",
        email: str = "",
        country: str = "",
        ue_country_prefix: str = "",
        bank_name: str | None = None,
        bank_account_number: str | None = None,
    ):
        self.contractor_type = contractor_type
        self.identifier_code = identifier_code
        self.short_name = short_name
        self.full_name = full_name
        self.city = city
        self.postal_code = postal_code
        self.address_line = address_line
        self.tax_id = tax_id
        self.regon = regon
        self.phone = phone
        self.fax = fax
        self.email = email
        self.country = country
        self.ue_country_prefix = ue_country_prefix
        self.bank_name = bank_name
        self.bank_account_number = bank_account_number

    @staticmethod
    def from_csv(csv_row) -> "Contractor":
        return Contractor(
            contractor_type=csv_row[0],
            identifier_code=str(csv_row[1]),
            short_name=csv_row[2],
            full_name=csv_row[3],
            city=csv_row[4],
            postal_code=csv_row[5],
            address_line=csv_row[6],
            tax_id=csv_row[7],
            regon=csv_row[8],
            phone=csv_row[9],
            fax=csv_row[10],
            email=csv_row[11],
            country=csv_row[27],
            ue_country_prefix=csv_row[28],
            bank_name=csv_row[25],
            bank_account_number=csv_row[26],
        )
