from xml.etree.ElementTree import Element, SubElement


class Seller:
    def __init__(
        self,
        iln: str,
        account_number: str | None,
        tax_id: str,
        name: str,
        street_and_number: str,
        city_name: str,
        postal_code: str,
        country: str,
        code_by_buyer: str | None = None,
        court_and_capital_information: str | None = None,
        utilization_register_number: str | None = None,
    ):
        self.iln = iln
        self.account_number = account_number
        self.tax_id = tax_id
        self.code_by_buyer = code_by_buyer
        self.name = name
        self.street_and_number = street_and_number
        self.city_name = city_name
        self.postal_code = postal_code
        self.country = country
        self.court_and_capital_information = court_and_capital_information
        self.utilization_register_number = utilization_register_number

    def to_xml(self) -> Element:
        """Return XML Element <Seller> with child tags and values."""
        seller_el = Element("Seller")

        fields = {
            "ILN": self.iln,
            "AccountNumber": self.account_number,
            "TaxID": self.tax_id,
            "CodeByBuyer": self.code_by_buyer,
            "Name": self.name,
            "StreetAndNumber": self.street_and_number,
            "CityName": self.city_name,
            "PostalCode": self.postal_code,
            "Country": self.country,
            "CourtAndCapitalInformation": self.court_and_capital_information,
            "UtilizationRegisterNumber": self.utilization_register_number,
        }

        for tag, value in fields.items():
            el = SubElement(seller_el, tag)
            el.text = str(value).strip() if value is not None else ""

        return seller_el
