from datetime import date
from xml.etree.ElementTree import Element, SubElement


class InvoiceDelivery:
    def __init__(
        self,
        delivery_location_number: str,
        delivery_date: date,
        name: str,
        street_and_number: str,
        city_name: str,
        postal_code: str,
        despatch_number: str,
    ):
        self.delivery_location_number = delivery_location_number
        self.delivery_date = delivery_date
        self.name = name
        self.street_and_number = street_and_number
        self.city_name = city_name
        self.postal_code = postal_code
        self.despatch_number = despatch_number

    def to_xml(self) -> Element:
        """Return XML Element <Delivery> with delivery details."""
        root = Element("Delivery")

        fields = {
            "DeliveryLocationNumber": self.delivery_location_number,
            "DeliveryDate": self.delivery_date,
            "Name": self.name,
            "StreetAndNumber": self.street_and_number,
            "CityName": self.city_name,
            "PostalCode": self.postal_code,
            "DespatchNumber": self.despatch_number,
        }

        for tag, value in fields.items():
            el = SubElement(root, tag)
            el.text = str(value).strip() if value is not None else ""

        return root
