from xml.etree.ElementTree import Element, SubElement


class Buyer:
    def __init__(
        self,
        iln: str,
        tax_id: str,
        name: str,
        street_and_number: str,
        city_name: str,
        postal_code: str,
        country: str,
    ):
        if not isinstance(iln, str):
            raise TypeError("iln must be a string")
        if not isinstance(tax_id, str):
            raise TypeError("tax_id must be a string")
        if not isinstance(name, str):
            raise TypeError("name must be a string")
        if not isinstance(street_and_number, str):
            raise TypeError("street_and_number must be a string")
        if not isinstance(city_name, str):
            raise TypeError("city_name must be a string")
        if not isinstance(postal_code, str):
            raise TypeError("postal_code must be a string")
        # if not isinstance(country, str):
        #     raise TypeError("country must be a string")

        self.iln = iln
        self.tax_id = tax_id
        self.name = name
        self.street_and_number = street_and_number
        self.city_name = city_name
        self.postal_code = postal_code
        self.country = country

    def to_xml(self) -> Element:
        buyer_el = Element("Buyer")

        fields = {
            "ILN": self.iln,
            "TaxID": self.tax_id,
            "Name": self.name,
            "StreetAndNumber": self.street_and_number,
            "CityName": self.city_name,
            "PostalCode": self.postal_code,
            "Country": self.country,
        }

        for tag, value in fields.items():
            el = SubElement(buyer_el, tag)
            el.text = str(value).strip() if value is not None else ""

        return buyer_el
