from userguide.views.base import BaseViewSet
from userguide.models import CategoryGroup
from userguide.serializers.category_group import PublicCategoryGroupSerializer

from .category_group_filterset import CategoryGroupFilterSet


class CategoryGroupViewSet(BaseViewSet):
    read_serializer = PublicCategoryGroupSerializer
    list_serializer = PublicCategoryGroupSerializer
    all_serializer = PublicCategoryGroupSerializer

    ordering_fields = (
        'title',
        'order',
        'total_categories',
        'description',
    )

    @property
    def filterset_class(self):
        return CategoryGroupFilterSet

    def get_queryset(self):
        """
        Returns an annotated queryset for the `CategoryGroup` model.
        :return: A queryset of `CategoryGroup` objects with annotations applied
        """
        return CategoryGroup.objects.with_annotations() \
            .prefetch_related('categories')