from django_filters.rest_framework import FilterSet
from django_filters.rest_framework import CharFilter
from django_filters.rest_framework import NumberFilter
from django_filters.rest_framework import BooleanFilter


# noinspection SpellCheckingInspection
class CategoryGroupFilterSet(FilterSet):
    title = CharFilter(field_name='name', lookup_expr='icontains')

    total_categories_min, total_categories_max = (
        NumberFilter(field_name='total_categories', lookup_expr='gte'),
        NumberFilter(field_name='total_categories', lookup_expr='lte'),
    )

    total_articles_min, total_articles_max = (
        NumberFilter(
            field_name='total_articles',
            lookup_expr='gte'
        ),
        NumberFilter(
            field_name='total_articles',
            lookup_expr='lte'
        ),
    )

    description = CharFilter(field_name='description', lookup_expr='icontains')
    icon = CharFilter(field_name='icon', lookup_expr='icontains')

    with_icon = BooleanFilter(method='with_icon_filter')

    exclude = NumberFilter(
        field_name='id',
        exclude=True
    )

    # noinspection PyMethodMayBeStatic
    def with_icon_filter(self, queryset, **kwargs):
        """
        Method filter to work with the ` with_icon ` parameter.

        If `with_icon` is `False`, then filter queryset to exclude categories with specified icons.
        If `with_icon` is `True`, then filter queryset to include categories with specified icons.
        If `with_icon` is not specified, then do nothing.

        :return: QuerySet
        """
        value = kwargs.get('value', None)

        if value is None:
            return queryset

        return queryset.filter(
            icon__isnull=(not value),
        )
