from django_filters.rest_framework import FilterSet
from django_filters.rest_framework import CharFilter
from django_filters.rest_framework import NumberFilter

from userguide.views.filters import MultiplePKFilter


# noinspection SpellCheckingInspection
class CategoryFilterSet(FilterSet):
    title = CharFilter(field_name='name', lookup_expr='icontains')
    content = CharFilter(field_name='description', lookup_expr='icontains')
    group = MultiplePKFilter(field_name='group')

    total_articles_min, total_articles_max = (
        NumberFilter(field_name='total_articles', lookup_expr='gte'),
        NumberFilter(field_name='total_articles', lookup_expr='lte'),
    )

    exclude = NumberFilter(
        field_name='id',
        exclude=True
    )
