from userguide.models import ArticleAttachment

from userguide.views.base import BaseViewSet

from userguide.serializers.article.attachment import PublicArticleAttachmentSerializer

from .article_attachment_filterset import ArticleAttachmentFilterSet


class ArticleAttachmentViewSet(BaseViewSet):
    """
    Handles operations related to article attachments.

    This class is responsible for managing article attachments by providing
    serializers for data representation and defining the data retrieval logic.
    It uses serializers for listing, reading, or processing all article
    attachments. The `get_queryset` method specifies the retrieval criteria for
    this data.
    """
    list_serializer = PublicArticleAttachmentSerializer
    read_serializer = PublicArticleAttachmentSerializer
    all_serializer = PublicArticleAttachmentSerializer

    ordering_fields = (
        'order',
    )

    @property
    def filterset_class(self):
        return ArticleAttachmentFilterSet

    def get_queryset(self):
        return ArticleAttachment.objects.get_queryset()