from django_filters.rest_framework import FilterSet
from django_filters.rest_framework import CharFilter
from django_filters.rest_framework import ChoiceFilter
from django_filters.rest_framework import NumberFilter

from userguide.models import ArticleAttachment
from userguide.views.filters import MultiplePKFilter


# noinspection SpellCheckingInspection
class ArticleAttachmentFilterSet(FilterSet):
    article_name = CharFilter(field_name='article__name', lookup_expr='icontains')
    article = MultiplePKFilter(field_name='article')
    type = ChoiceFilter(choices=ArticleAttachment.Type.choices, lookup_expr='iexact')
    exclude = NumberFilter(field_name='id', exclude=True)