from django.urls import path, include
from rest_framework.routers import DefaultRouter

from userguide.views.article import ArticleViewSet
from userguide.views.article.attachment import ArticleAttachmentViewSet
from userguide.views.category import CategoryViewSet
from userguide.views.category_group import CategoryGroupViewSet

router = DefaultRouter()

router.register(r'article', ArticleViewSet, basename='article')

router.register(r'category', CategoryViewSet, basename='category')

router.register(r'article-attachment', ArticleAttachmentViewSet, basename='article-attachment')

router.register(r'category-group', CategoryGroupViewSet, basename='category-group')

urlpatterns = [
    path('user-guide/', include(router.urls)),
]