from userguide.models import Category
from userguide.serializers.base import PublicSerializer

from rest_framework.serializers import ImageField


class VerySimpleCategorySerializer(
    PublicSerializer,
):
    """
    Very simple category serializer.

    To serialize a category, only the title, order and image attributes are included.
    Usually to use in other serializers to represent the category(s) data e.g., CategoryGroup serializer.
    """
    image = ImageField()

    class Meta:
        model = Category
        fields = ('title', 'order', 'image',)