from userguide.models import Article
from userguide.serializers.base import PublicSerializer


class VerySimpleArticleSerializer(
    PublicSerializer,
):
    """
    Very simple article serializer.

    To serialize an article, only the title and order attributes are included.
    Usually, to use in other serializers to represent the article(s) data e.g., Category serializer.
    """
    class Meta:
        model = Article
        fields = ('title', 'order',)
