from userguide.models import Category
from userguide.serializers.base import PublicSerializer


class VerySimpleCategorySerializer(PublicSerializer):
    """
    Very simple category serializer.

    To serialize a category, only the title, order and group_id attributes are included.
    Usually, to use in other serializers to represent the article(s) data e.g., Article serializer.
    """
    class Meta:
        model = Category
        fields = ('title', 'order', 'group_id',)