from userguide.models import Article
from userguide.serializers.base import PublicSerializer
from userguide.serializers.base import TruncateCharField

from rest_framework.serializers import IntegerField

from .very_simple_category_serializer import VerySimpleCategorySerializer

class SimpleArticleSerializer(
    PublicSerializer,
):
    category = VerySimpleCategorySerializer(read_only=True)
    content = TruncateCharField()
    total_attachments = IntegerField(read_only=True, allow_null=True)

    next_article_id = IntegerField(read_only=True, allow_null=True)
    previous_article_id = IntegerField(read_only=True, allow_null=True)

    class Meta:
        model = Article
        fields = (
            'title',
            'content',
            'category',
            'order',
            'total_attachments',
            'next_article_id',
            'previous_article_id',
        )